<?php
// https://techhub.com.ng/skent/src/ServerApi - Single endpoint handler for Skill Enterprise

session_start();
global $conn;
$listPaPage  = 10;

// Configuration
$admin_username = "admin";
$admin_password = "your_secure_password_hash"; // Store hashed password
$secret_key = "secureHidingSkilleneter63324k0404y"; 
//$listPaPage = 10;
//this API page is location https://techhub.com.ng/skent/src/ServerApi   accessed using serveraction = required action 
session_start();


header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, PUT, DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$showError = true;

if ($showError) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
}




// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'skillenter');
define('DB_PASS', 'Skent@2024');
define('DB_NAME', 'skillenter');

// Initialize database connection
function getDb() {
    static $db = null;
    if ($db === null) {
        $db = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        if ($db->connect_error) {
            die(json_response(false, 'Database connection failed: ' . $db->connect_error));
        }
        $db->set_charset("utf8mb4");
    }
    return $db;
}



// Helper function for JSON responses
function json_response($success, $message = '', $data = null) {
    header('Content-Type: application/json');
    $response = ['success' => $success];
    if ($message) $response['message'] = $message;
    if ($data !== null) $response['data'] = $data;
    return json_encode($response);
}

// Authentication check
function checkAuth($required_roles = ['student', 'admin', 'supervisor', 'manager', 'super_admin']) {
    session_start();
    if (!isset($_SESSION['user_id'])) {
        http_response_code(401);
        die(json_response(false, 'Authentication required'));
    }
    if (!in_array($_SESSION['role'], $required_roles)) {
        http_response_code(403);
        die(json_response(false, 'Unauthorized access'));
    }
    return $_SESSION['user_id'];
}

// Main request handler
try {
    if (!isset($_REQUEST['serveraction'])) {
        throw new Exception('Server action is required');
    }

    $action = $_REQUEST['serveraction'];

    require_once('../src/.env/db_config.php');

// Get database connection
$db = getDBConnection();
 //   $db = getDb();
    
    switch ($action) {
        case 'login':
            $data = json_decode(file_get_contents('php://input'), true);
            $email = $data['email'] ?? '';
            $password = $data['password'] ?? '';
            
            $stmt = $db->prepare("SELECT id, name, email, role, password_hash FROM users WHERE email = ?");
            $stmt->bind_param("s", $email);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($user = $result->fetch_assoc()) {
                if (password_verify($password, $user['password_hash'])) {
                    session_start();
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['role'] = $user['role'];
                    
                    echo json_response(true, 'Login successful', [
                        'user' => [
                            'id' => $user['id'],
                            'name' => $user['name'],
                            'email' => $user['email'],
                            'role' => $user['role']
                        ]
                    ]);
                } else {
                    throw new Exception('Invalid credentials');
                }
            } else {
                throw new Exception('User not found');
            }
            break;

        case 'register':
            $data = json_decode(file_get_contents('php://input'), true);
            $name = $data['name'] ?? '';
            $email = $data['email'] ?? '';
            $password = $data['password'] ?? '';
            $token = $data['token'] ?? null;
            
            // Start transaction
            $db->begin_transaction();
            
            try {
                // Check token if provided
                if ($token) {
                    $stmt = $db->prepare("SELECT course_id, max_users, used_count FROM tokens WHERE token = ? AND active = 1");
                    $stmt->bind_param("s", $token);
                    $stmt->execute();
                    $token_result = $stmt->get_result();
                    
                    if ($token_data = $token_result->fetch_assoc()) {
                        if ($token_data['used_count'] >= $token_data['max_users']) {
                            throw new Exception('Token has reached maximum usage');
                        }
                    } else {
                        throw new Exception('Invalid token');
                    }
                }
                
                // Check email uniqueness
                $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
                $stmt->bind_param("s", $email);
                $stmt->execute();
                if ($stmt->get_result()->num_rows > 0) {
                    throw new Exception('Email already registered');
                }
                
                // Create user
                $password_hash = password_hash($password, PASSWORD_DEFAULT);
                $role = 'student';
                
                $stmt = $db->prepare("INSERT INTO users (name, email, password_hash, role) VALUES (?, ?, ?, ?)");
                $stmt->bind_param("ssss", $name, $email, $password_hash, $role);
                $stmt->execute();
                $user_id = $db->insert_id;
                
                // Handle token enrollment
                if ($token && isset($token_data)) {
                    $stmt = $db->prepare("INSERT INTO course_enrollments (user_id, course_id) VALUES (?, ?)");
                    $stmt->bind_param("ii", $user_id, $token_data['course_id']);
                    $stmt->execute();
                    
                    $stmt = $db->prepare("UPDATE tokens SET used_count = used_count + 1 WHERE token = ?");
                    $stmt->bind_param("s", $token);
                    $stmt->execute();
                }
                
                $db->commit();
                echo json_response(true, 'Registration successful');
                
            } catch (Exception $e) {
                $db->rollback();
                throw $e;
            }
            break;

        case 'generateToken':
            checkAuth(['admin', 'supervisor', 'manager', 'super_admin']);
            $data = json_decode(file_get_contents('php://input'), true);
            $course_id = $data['courseId'] ?? 0;
            $max_users = $data['maxUsers'] ?? 1;
            
            $token = bin2hex(random_bytes(16));
            
            $stmt = $db->prepare("INSERT INTO tokens (token, course_id, max_users, created_by) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("siii", $token, $course_id, $max_users, $_SESSION['user_id']);
            $stmt->execute();
            
            echo json_response(true, 'Token generated successfully', ['token' => $token]);
            break;

        case 'addCourse':
            checkAuth(['admin', 'supervisor', 'manager', 'super_admin']);
            $data = json_decode(file_get_contents('php://input'), true);
            $playlist_url = $data['playlistUrl'] ?? '';
            
            preg_match('/list=([a-zA-Z0-9_-]+)/', $playlist_url, $matches);
            if (!isset($matches[1])) {
                throw new Exception('Invalid playlist URL');
            }
            
            $playlist_id = $matches[1];
            $api_key = 'YOUR_YOUTUBE_API_KEY';
            $playlist_data = file_get_contents("https://www.googleapis.com/youtube/v3/playlistItems?part=snippet&maxResults=50&playlistId={$playlist_id}&key={$api_key}");
            $playlist_data = json_decode($playlist_data, true);
            
            if (!$playlist_data || !isset($playlist_data['items'])) {
                throw new Exception('Failed to fetch playlist data');
            }
            
            $db->begin_transaction();
            
            try {
                $stmt = $db->prepare("INSERT INTO courses (title, playlist_id, created_by) VALUES (?, ?, ?)");
                $course_title = $playlist_data['items'][0]['snippet']['channelTitle'];
                $stmt->bind_param("ssi", $course_title, $playlist_id, $_SESSION['user_id']);
                $stmt->execute();
                $course_id = $db->insert_id;
                
                $stmt = $db->prepare("INSERT INTO videos (course_id, title, youtube_id, position) VALUES (?, ?, ?, ?)");
                foreach ($playlist_data['items'] as $position => $item) {
                    $video_title = $item['snippet']['title'];
                    $video_id = $item['snippet']['resourceId']['videoId'];
                    $stmt->bind_param("issi", $course_id, $video_title, $video_id, $position);
                    $stmt->execute();
                }
                
                $db->commit();
                echo json_response(true, 'Course added successfully', ['courseId' => $course_id]);
                
            } catch (Exception $e) {
                $db->rollback();
                throw $e;
            }
            break;

        case 'saveProgress':
            $user_id = checkAuth(['student']);
            $data = json_decode(file_get_contents('php://input'), true);
            $course_id = $data['courseId'] ?? 0;
            $video_index = $data['videoIndex'] ?? 0;
            $completed = $data['completed'] ?? false;
            
            $stmt = $db->prepare("
                INSERT INTO progress (user_id, course_id, video_index, completed)
                VALUES (?, ?, ?, ?)
                ON DUPLICATE KEY UPDATE completed = ?, last_watched_at = CURRENT_TIMESTAMP
            ");
            $stmt->bind_param("iiibb", $user_id, $course_id, $video_index, $completed, $completed);
            $stmt->execute();
            
            echo json_response(true, 'Progress saved successfully');
            break;

        case 'getCourse':
            $user_id = checkAuth();
            $course_id = $_GET['courseId'] ?? 0;
            
            // Get course details and check enrollment
            $stmt = $db->prepare("
                SELECT c.*, ce.id as enrolled
                FROM courses c
                LEFT JOIN course_enrollments ce ON ce.course_id = c.id AND ce.user_id = ?
                WHERE c.id = ?
            ");
            $stmt->bind_param("ii", $user_id, $course_id);
            $stmt->execute();
            $course = $stmt->get_result()->fetch_assoc();
            
            if (!$course) {
                throw new Exception('Course not found');
            }
            
            if (!$course['enrolled'] && $_SESSION['role'] === 'student') {
                throw new Exception('Not enrolled in this course');
            }
            
            // Get videos and progress
            $stmt = $db->prepare("
                SELECT v.*, p.completed, p.last_watched_at
                FROM videos v
                LEFT JOIN progress p ON p.video_index = v.position 
                    AND p.course_id = v.course_id 
                    AND p.user_id = ?
                WHERE v.course_id = ?
                ORDER BY v.position
            ");
            $stmt->bind_param("ii", $user_id, $course_id);
            $stmt->execute();
            $videos = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            
            $course['videos'] = $videos;
            echo json_response(true, '', $course);
            break;

        case 'logout':
            session_start();
            session_destroy();
            echo json_response(true, 'Logged out successfully');
            break;

        default:
            throw new Exception('Invalid server action');
    }

} catch (Exception $e) {
    http_response_code(400);
    echo json_response(false, $e->getMessage());
}
?>